function am_lab1
% AM_LAB1 Recreates the results of the AM lab
%   am_lab1
%
%   Text here
%
%   x:  Variables here

% ------- am_lab1.m ----------------------------------------
% Marios Athineos, marios@ee.columbia.edu
% http://www.ee.columbia.edu/~marios/
% Copyright (c) 2003 by Columbia University.
% All rights reserved.
% ----------------------------------------------------------

% Define the sampling frequency in Hz
fs  = 2000;
len = 1; % length of signals in seconds
t   = (-len/2):1/fs:(len/2); % time index
% Make our first modulating (message) signal m(t)
fm  = 0.5; % modulator frequency (Hz)
m   = cos(2*pi*fm*t) - 0.25;
% Now make the carrier c(t)
fc = 20; % carrier frequency
c  = cos(2*pi*fc*t);
% Modulate the signal
u  = m.*c;
% Let's plot them in time to see how they look like
am_plot(t,m,c,u,1.1);
% Calculate the spectra
M = am_spectrum(m);
C = am_spectrum(c);
U = am_spectrum(u);
% Make the frequency index for plotting
f = (-fs/2):(1/len):(fs/2);
% Now let's plot them in frequency
am_plot(f,M,C,U,0.1);

% ----------------------------------------------------------

% Now make the second message signal
pw = 0.1; % pulse width
m  = rectpuls(t,pw);
% Now make a new carrier
fc = 60; % carrier frequency
c  = cos(2*pi*fc*t);
% Modulate the signal
u  = m.*c;
% Let's plot them in time to see how they look like
am_plot(t,m,c,u,1.1);
% Lets look at the spectra
M = am_spectrum(m);
C = am_spectrum(c);
U = am_spectrum(u);
% Make the frequency index for plotting
f = (-fs/2):(1/len):(fs/2);
% Now let's plot them in frequency
am_plot(f,M,C,U,0.1);

% ----------------------------------------------------------

% Now change the parameters
pw = 0.05; % pulse width
m  = rectpuls(t,pw);
% Now make a new carrier
fc = 15; % carrier frequency
c  = cos(2*pi*fc*t);
% Modulate the signal
u  = m.*c;
% Let's plot them in time to see how they look like
am_plot(t,m,c,u,1.1);
% Lets look at the spectra
M = am_spectrum(m);
C = am_spectrum(c);
U = am_spectrum(u);
% Make the frequency index for plotting
f = (-fs/2):(1/len):(fs/2);
% Now let's plot them in frequency
am_plot(f,M,C,U,0.1);
